


#include <iostream>
#include <string.h>
#include <stdio.h>
#include <string> 

#include <map>
#include <functional>
#include <utility>

#include <algorithm>


//http://kin.naver.com/qna/detail.nhn?d1id=1&dirId=1040101&docId=140834379&qb=66mA7YuwIOuntSBzdGw=&enc=utf8&section=kin&rank=4&search_sort=0&spq=0

using namespace std;


class CMyEntity
{
public:
    unsigned int m_iIndex;
    int m_iNumber;
public:
    CMyEntity()
    {
    }
    CMyEntity(unsigned int iIndex, int iNumber)
    {
        printf("CMyManager::AddEntity(%d, %d)\n", iIndex, iNumber);
        m_iIndex  = iIndex;
        m_iNumber = iNumber;
    }
    
    ~CMyEntity()
    {
        printf("~CMyEntity\n");
    }
private:
    CMyEntity(const CMyEntity& cp)
    {
        printf("CMyEntity(const CMyEntity& cp)\n");
    }
    CMyEntity& operator=(const CMyEntity& cp)
    {
        printf("CMyEntity& operator=(const CMyEntity& cp)\n");
    }

};


bool myComparison( pair<int,CMyEntity*>& a, pair<int,CMyEntity*>& b)
{
       return 1;
}



class A : public CMyEntity
{
public:
    int m_iAcc;
public:
    A()
    {
    }
    A(unsigned int iIndex, int iNumber,int iAcc) : CMyEntity(iIndex, iNumber)
    {
        m_iAcc = iAcc;
    }
    ~A()
    {
    }
};


class B : public CMyEntity
{
public:
    double m_dNum;
public:
    B()
    {
    }
    B(unsigned int iIndex, int iNumber, double dNum) : CMyEntity(iIndex, iNumber)
    {
        m_dNum = dNum;
    }
    ~B()
    {
    }
};


class C : public B
{
public:
    char* m_cName;
public:
    C()
    {
    }
    C(unsigned int iIndex, int iNumber, double dNum, char* cName) : B(iIndex, iNumber, dNum)
    {
        m_cName = new char[strlen(cName)+1];
        strcpy(m_cName,cName);
    }
    ~C()
    {
    }
};



//http://forums.codeguru.com/showthread.php?243809-sorting-a-multimap
class CMyArray
{
public:
    std::multimap<int,CMyEntity*, equal_to<int>> m_mapEntity;
public:
    CMyArray();
    ~CMyArray();
    void AddEntity(CMyEntity* myEntity);
    void PrintEntity();
private:
    CMyArray(const CMyArray& cp) {}
    CMyArray& operator=(const CMyArray& cp) {}
};



#if 1
//http://blog.naver.com/kim519620?Redirect=Log&logNo=220453395911

#endif


struct classcomp 
{
//    bool operator() (const int& lhs, const CMyEntity*& rhs) const
//    {return lhs<rhs;}
};



CMyArray::CMyArray(void)
{

//pairless(m_mapEntity.begin(), m_mapEntity.end());
//  std::multimap<int,CMyEntity*,classcomp> fourth;                 // class as Compare

//    std::sort(m_mapEntity.begin(), m_mapEntity.end(), Cmp<pair<int, CMyEntity*> >());
  
//    std::sort(m_mapEntity.begin(), m_mapEntity.end(), compare_pair_second<std::equal_to>());
//std::sort(m_mapEntity.begin(), m_mapEntity.end(), 
//          boost::bind(&std::pair<int, int>::second, _1) ==
//          boost::bind(&std::pair<int, int>::second, _2));


//sort(m_mapEntity.begin(),m_mapEntity.end(),myComparison);

}

CMyArray::~CMyArray(void)
{
}

void CMyArray::AddEntity(CMyEntity* myEntity)
{
    printf("CMyArray::AddEntity() %d %d\n",myEntity->m_iIndex,myEntity->m_iNumber);
    m_mapEntity.insert(make_pair(myEntity->m_iIndex,myEntity));

}

void CMyArray::PrintEntity()
{

    std::multimap<int,CMyEntity*, equal_to<int>>::iterator itr;
    
    for(itr = m_mapEntity.begin(); itr != m_mapEntity.end(); itr++)
    {
        printf("ε : %d  ȣ : %d\n",itr->second->m_iIndex,itr->second->m_iNumber);
    }
}


class CMyManager
{
public:
    CMyManager(CMyArray* myArray);
    ~CMyManager();

    void AddEntity(unsigned int index, int num);
    void AddEntity(CMyEntity* myEntity);
    void Print();
    
    
    CMyArray * m_myArray;
};


CMyManager::CMyManager(CMyArray* myArray)
{
    m_myArray = myArray;
}

CMyManager::~CMyManager()
{
    delete m_myArray;
}

void CMyManager::AddEntity(unsigned int index, int num)
{
    printf("CMyManager::AddEntity(%d, %d)\n", index, num);
    CMyEntity* myEntity = new CMyEntity(index,num);
    m_myArray->AddEntity(myEntity); 
}

void CMyManager::AddEntity(CMyEntity* myEntity)
{
    printf("CMyManager::AddEntity( CMyEntity* myEntity )\n");
    m_myArray->AddEntity(myEntity); 
}

void CMyManager::Print()
{
    m_myArray->PrintEntity();
}


class CMyController
{
public:
    CMyController(CMyManager * myManager){  m_myManager = myManager; };
    ~CMyController(){};
    
    void AddEntity(unsigned int index, int num);
    void AddEntity(CMyEntity * myEntity);
    void Print();
    
    CMyManager * m_myManager;
};


void CMyController::AddEntity(unsigned int index, int num)
{
    printf("CMyController::AddEntity(%d, %d)\n", index, num);
    if(m_myManager == NULL)
    {
        printf("m_myManager == NULL\n");
        return ;
    }
    m_myManager->AddEntity(index,num);
}


void CMyController::AddEntity(CMyEntity * myEntity)
{
    printf("CMyController::AddEntity( CMyEntity * myEntity )\n");
    if(m_myManager == NULL)
    {
        printf("m_myManager == NULL\n");
        return ;
    }
    m_myManager->AddEntity(myEntity);
}

void CMyController::Print()
{
    m_myManager->Print();
}
 
 
int main(int argc, char** argv) 
{
    //Ʈѷ ؼ Ƽ ϴ  ־.
    CMyArray        * myArray       = new CMyArray();
    CMyManager      * myManager     = new CMyManager(myArray);
    CMyController   * myController  = new CMyController(myManager);

    unsigned int iIndex = 0;
    int num = 0;

    for(int i = 0; i<3; i++)
    {
        printf("ε  Է : ");
//        scanf("%d",&iIndex);
iIndex = 5;
        printf("ȣ Է : ");
//        scanf("%d",&num);
num = 50;
        myController->AddEntity(iIndex,num);
    }
    printf("\n");

    //Ŭ 迭 ϱؼ. ڸ ߰ش. 
    //Error] no matching function for call to 'B::B()'

    //Ŭ νϽ ߰ϱ  Լ ش. 

    //undefined reference to `C::~C()'
    //~Ҹ {} ڵ κе ߰ش.


    //4Ʈ Ŭ  2 迭 
    A * a[2];
    B * b[2];
    C * c[2];

    printf("\n");
    CMyEntity e1(1,10);
    CMyEntity e2(2,20);
    CMyEntity e3(3,30);
    
    printf("\n");
    myController->AddEntity(&e1);


    struct equal_to;
    struct not_equal_to;
    struct greater;
    struct less;
    struct greater_equal;
    struct less_equal;

    a[0] = (A*) &e1;
    a[1] = (A*) &e1;
    b[0] = (B*) &e2;
    b[1] = (B*) &e2;
    c[0] = (C*) &e3;
    c[1] = (C*) &e3;

    printf("\n");
    myController->AddEntity(a[0]);
    myController->AddEntity(a[1]);
    myController->AddEntity(b[0]);
    myController->AddEntity(b[1]);
    myController->AddEntity(c[0]);
    myController->AddEntity(c[1]);

    printf("\n");
    myController->Print();

//    delete [] a;
//    delete [] b;
//    delete [] c;

	return 0;
}



#if 0

ε  Է : ȣ Է : CMyController::AddEntity(5, 50)
CMyManager::AddEntity(5, 50)
CMyManager::AddEntity(5, 50)
CMyArray::AddEntity() 5 50
ε  Է : ȣ Է : CMyController::AddEntity(5, 50)
CMyManager::AddEntity(5, 50)
CMyManager::AddEntity(5, 50)
CMyArray::AddEntity() 5 50
ε  Է : ȣ Է : CMyController::AddEntity(5, 50)
CMyManager::AddEntity(5, 50)
CMyManager::AddEntity(5, 50)
CMyArray::AddEntity() 5 50


CMyManager::AddEntity(1, 10)
CMyManager::AddEntity(2, 20)
CMyManager::AddEntity(3, 30)

CMyController::AddEntity( CMyEntity * myEntity )
CMyManager::AddEntity( CMyEntity* myEntity )
CMyArray::AddEntity() 1 10

CMyController::AddEntity( CMyEntity * myEntity )
CMyManager::AddEntity( CMyEntity* myEntity )
CMyArray::AddEntity() 1 10
CMyController::AddEntity( CMyEntity * myEntity )
CMyManager::AddEntity( CMyEntity* myEntity )
CMyArray::AddEntity() 1 10
CMyController::AddEntity( CMyEntity * myEntity )
CMyManager::AddEntity( CMyEntity* myEntity )
CMyArray::AddEntity() 2 20
CMyController::AddEntity( CMyEntity * myEntity )
CMyManager::AddEntity( CMyEntity* myEntity )
CMyArray::AddEntity() 2 20
CMyController::AddEntity( CMyEntity * myEntity )
CMyManager::AddEntity( CMyEntity* myEntity )
CMyArray::AddEntity() 3 30
CMyController::AddEntity( CMyEntity * myEntity )
CMyManager::AddEntity( CMyEntity* myEntity )
CMyArray::AddEntity() 3 30

ε : 5  ȣ : 50
ε : 5  ȣ : 50
ε : 5  ȣ : 50
ε : 1  ȣ : 10
ε : 1  ȣ : 10
ε : 1  ȣ : 10
ε : 2  ȣ : 20
ε : 2  ȣ : 20
ε : 3  ȣ : 30
ε : 3  ȣ : 30
~CMyEntity
~CMyEntity
~CMyEntity

--------------------------------
Process exited after 1.251 seconds with return value 0
Ϸ ƹ Ű ʽÿ . . .

#endif



